#!/bin/bash

# Interactive setup script for AWS DevOps Agent and Dynatrace

echo "=== AWS DevOps Agent Configuration ==="
read -p "Enter AgentSpace webhook URL: " webhook_url
read -p "Enter Dynatrace Credential Vault entry id to load the authentication token from: " vault_entry_id

echo ""
echo "=== Experience Configuration ==="
while true; do
    read -p "Do you want to create Troubleshooting Guide Notebooks (Warning: this can generate many Dynatrace Notebooks, one per Dynatrace Problem)? (yes/no): " create_notebooks
    case $create_notebooks in
        [Yy]es|[Yy]) create_notebooks="true"; break;;
        [Nn]o|[Nn]) create_notebooks="false"; break;;
        *) echo "Please answer yes or no.";;
    esac
done

echo ""
echo "=== Configuration Summary ==="
echo "Webhook URL: $webhook_url"
echo "Vault Entry ID: $vault_entry_id"
echo "Create Notebooks: $create_notebooks"
# Ask for confirmation
while true; do
    read -p "Is this configuration correct? Do you want to proceed? (yes/no): " confirm
    case $confirm in
        [Yy]es|[Yy]) break;;
        [Nn]o|[Nn]) echo "Configuration cancelled. Exiting..."; exit 1;;
        *) echo "Please answer yes or no.";;
    esac
done

mkdir out 

cp 01* out/
cp 02* out/
cp 04* out/
cp 06* out/
sed "s,credentialVaultId_REPLACE_ME,$vault_entry_id,g; s,awsDevOpsAgentEndpoint_REPLACE_ME,$webhook_url,g" "03_Check eligibility and invoke AWS DevOps Agent.yaml" > "out/03_Check eligibility and invoke AWS DevOps Agent.yaml"
sed "s,credentialVaultId_REPLACE_ME,$vault_entry_id,g; s,awsDevOpsAgentEndpoint_REPLACE_ME,$webhook_url,g" "05_Handle AWS DevOps Agent investigation completed responses.yaml" > "out/05_Handle AWS DevOps Agent investigation completed responses.yaml"
sed "s,createTSGNotebooks: false,createTSGNotebooks: $create_notebooks,g" "04_Handle AWS DevOps Agent investigation responses.yaml" > "out/04_Handle AWS DevOps Agent investigation responses.yaml"
sed "s,updateTSGNotebooks: false,updateTSGNotebooks: $create_notebooks,g" "06_Handle AWS DevOps Agent mitigation responses.yaml" > "out/06_Handle AWS DevOps Agent mitigation responses.yaml"


echo "=== Don't forget, use the files from the out folder! ==="
